/**
 * \file: AudioSourceChannel.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto
 *
 * \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
 *
 * \copyright (c) 2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include <aauto/AditAudioSource.h>
#include "AudioSourceChannel.h"
#include "DemoFactory.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

AudioSourceChannel::AudioSourceChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId,
                                       IDynamicConfiguration& inConfig) :
    receiver(inReceiver), sessionId(inSessionId), mConfig(&inConfig)
{
}

AudioSourceChannel::~AudioSourceChannel()
{
    endpoint = nullptr;
}

void AudioSourceChannel::shutdown()
{
    LOG_INFO((demo, "audio source channel shut down"));
    if(endpoint != nullptr) {
        endpoint->shutdown();
    }
}

bool AudioSourceChannel::Initialize()
{
    LOG_INFO((demo, "Creating new Audio source..."));
    auto creator = DemoFactory::instance().getCreator
            <AditAudioSource, AudioSourceCreatorFn>(mConfig->GetItem("adit-audio-source", ""));
    if (creator != nullptr)
    {
        endpoint = creator(sessionId, receiver->messageRouter(), MEDIA_CODEC_AUDIO_PCM);
    }
    else
    {
        LOG_ERROR((demo, "failed to get creator object"));
    }

    if(endpoint != nullptr)
    {
        LOGD_DEBUG((demo, "Completed the initialization of audio-source"));
    }
    else
    {
        LOG_ERROR((demo, "error create AudioSourceImpl"));
        return false;
    }

    /* get list of AudioSource configuration values */
    std::list<std::string> audio_source = mConfig->GetItems("audio-source");
    for (auto node : audio_source)
    {
        std::string key;
        std::string value;
        /* get key and respective value from node entry */
        mConfig->GetNodeItem(node, key, value);

        /* Configuration for AudioSource Endpoint */
        endpoint->setConfigItem(key, value);
    }

    endpoint->registerCallbacks(this);

    if(!endpoint->init())
    {
        LOG_ERROR((demo, "error endpoint->init()"));
        return false;
    }

    LOGD_DEBUG((demo, "mGalReceiver->registerService<AudioSource>"));
    // The argument of API is done const_cast because GalReceiver requires non const pointer.
    return receiver->registerService(const_cast<AditAudioSource*>(endpoint.get()));
}

int AudioSourceChannel::microphoneRequestCallback(bool open, bool ancEnabled, bool ecEnabled)
{
    LOGD_DEBUG((demo, "AudioSourceChannel::microphoneRequestCallback"));
    return STATUS_SUCCESS;
}

void AudioSourceChannel::notifyErrorCallback(aautoErrorCodes inErrorCode)
{
    LOG_ERROR((demo, "AudioSourceChannel::notifyErrorCallback: %d", inErrorCode));
}

} } // namespace adit { namespace aauto
